import argparse
import logging

from crypta.s2s.services.conversions_downloader.lib.encrypter import Encrypter
from crypta.s2s.tools.lib.environment import Environment
from crypta.s2s.tools.lib.vault import Vault


logger = logging.getLogger(__name__)


def add_args_subparser(subparsers):
    parser = subparsers.add_parser(
        "encrypt",
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description=(
            "Encypt string using direct encription secret"
            "Examples:\n"
            "  crypta-s2s-tools encrypt --environment testing <...>  # testing\n"
            "  crypta-s2s-tools encrypt --environment production <...>  # prodution\n"
        )
    )

    parser.set_defaults(function=main)

    parser.add_argument("--environment", choices=Environment.all(), required=True)
    parser.add_argument("value", help="Value to encrypt")


def main(
    environment,
    value,
):
    direct_encryption_secret = Vault().get_direct_encryption_secret(environment)
    encrypter = Encrypter(direct_encryption_secret.encode())
    print(encrypter.encrypt(value).decode())
    return 0
