import argparse
import logging

from crypta.s2s.tools.lib import grut
from crypta.s2s.tools.lib.environment import Environment


logger = logging.getLogger(__name__)


def add_args_subparser(subparsers):
    parser = subparsers.add_parser(
        "get-conversion-source",
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description=(
            "Get converson source by id"
            "Examples:\n"
            "  crypta-s2s-tools get-conversion-source --environment testing --conversion-source-id 1111\n"
        )
    )

    parser.set_defaults(function=main)

    parser.add_argument("--environment", choices=Environment.all(), required=True)
    parser.add_argument("--conversion-source-id", help="Id of conversion source", required=True)


def main(
    environment,
    conversion_source_id,
):
    conversion_source_client = grut.get_conversion_source_client(environment, logger)
    conversion_source = conversion_source_client.get(conversion_source_id, grut.ATTRIBUTE_SELECTOR)

    if conversion_source is None:
        logger.warn("Unknown conversion source")
        return 0

    print(conversion_source)
    return 0
