import argparse
import datetime
import logging

from crypta.s2s.services.conversions_processor.lib.parsers.crm_api_csv_parser import CrmApiCsvParser


logger = logging.getLogger(__name__)


def add_args_subparser(subparsers):
    parser = subparsers.add_parser(
        "parse-csv",
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description=(
            "Parse csv file"
            "Examples:\n"
            "  crypta-s2s-tools parse-csv --source-path <...> --destination-path <...> --errors-path <...>\n"
        )
    )

    parser.set_defaults(function=main)

    parser.add_argument("--source-path", help="Path to csv file to parse", required=True)
    parser.add_argument("--destination-path", help="Path to file with valid rows", required=True)
    parser.add_argument("--errors-path", help="Path to file with errors", required=True)
    parser.add_argument("--freshness-period-days", help="How old orders can be in days", default=30, type=int)


def main(
    source_path,
    destination_path,
    errors_path,
    freshness_period_days,
):
    min_create_date_time = datetime.datetime.utcnow() - datetime.timedelta(days=freshness_period_days)
    parser = CrmApiCsvParser(order_status_to_revenue={}, min_create_date_time=min_create_date_time)
    parser.parse(source_path=source_path, destination_path=destination_path, errors_path=errors_path)
    return 0
