from grut.python.object_api.client import ObjectApiClient

from crypta.s2s.lib.conversion_source_client import ConversionSourceClient
from crypta.s2s.tools.lib.environment import Environment
from crypta.s2s.tools.lib.vault import Vault


ATTRIBUTE_SELECTOR = ["/meta/id", "/meta/type_code", "/meta/client_id", "/spec"]


def get_conversion_source_client(environment, logger):
    object_api_client = ObjectApiClient(
        address="testing" if environment == Environment.testing else "stable",
        transport="grpc",
        config={
            "enable_ssl": False,
            "token": Vault().get_grut_token(environment),
        },
        allow_receive_token_by_ssh_session=False,
    )
    return ConversionSourceClient(object_api_client, logger)
