import logging

from library.python.vault_client.instances import Production as VaultClient

from crypta.s2s.tools.lib.environment import Environment


logger = logging.getLogger(__name__)


class Vault:
    direct_encryption_secret = {
        Environment.testing: "sec-01g0y6m836nb4cbtm5vwx9jcnz",
        Environment.production: "sec-01g0y6x1rbb66tpcwbd2emnb8z",
    }
    grut_token = {
        Environment.testing: "sec-01g4j5be6c5hk8wfptw0k55b0h",
        Environment.production: "sec-01fz0fwdxnsvjmrxwykqcmzr8s",
    }
    conversions_processor_tvm_secret = {
        Environment.testing: "sec-01fyebsjvz7560q0cc4ef0vw9m",
        Environment.production: "sec-01fyebrvdtde1xm6fbw195m1pq",
    }

    def __init__(self):
        self.client = VaultClient()

    def _get_secret(self, environment, environment_to_secret, key):
        version = environment_to_secret[environment]
        data = self.client.get_version(version)
        return data["value"][key]

    def get_direct_encryption_secret(self, environment):
        return self._get_secret(environment, self.direct_encryption_secret, "encrypter-secret")

    def get_grut_token(self, environment):
        return self._get_secret(environment, self.grut_token, "token")

    def get_conversions_processor_tvm_secret(self, environment):
        return self._get_secret(environment, self.conversions_processor_tvm_secret, "client_secret")
