package ru.yandex.crypta.search;

import java.util.List;

import javax.inject.Inject;

import org.glassfish.jersey.internal.inject.InjectionManager;

import ru.yandex.crypta.clients.redis.RedisClient;

public class MatchersRepository {

    private final List<Matcher> matchers;
    private final MatchersStats stats;

    @Inject
    public MatchersRepository(InjectionManager injector, RedisClient redisClient) {
        this.matchers = Matcher.createAllMatchers(injector);
        this.stats = new MatchersStats(redisClient);
    }

    public List<Matcher> getMatchers() {
        return matchers;
    }

    public MatchersStats getStats() {
        return stats;
    }
}
