package ru.yandex.crypta.search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.clients.redis.RedisClient;

public class MatchersStats {

    private static final Logger LOG = LoggerFactory.getLogger(MatchersStats.class);

    private final RedisClient redis;

    public MatchersStats(RedisClient redisClient) {
        redis = redisClient;
    }

    public void increment(String matcher) {
        try {
            redis.incr(getClass(), matcher, "usage");
        } catch (Exception e) {
            LOG.error("Unable to update usage stats for matcher " + matcher);
        }
    }

    public long getUsageCount(String matcher) {
        return redis.getLong(getClass(), matcher, "usage");
    }
}
