package ru.yandex.crypta.search;

import java.util.Comparator;

import ru.yandex.crypta.search.proto.Search;

public class Ranking {

    public static Comparator<Search.TResponse.Builder> createComparator() {
        return Comparator.comparing(response -> {
            if (response.getValue().hasError()) {
                return Integer.MAX_VALUE;
            }
            if (response.getValue().hasUserDataStats()) {
                return 10;
            }
            return 0;
        });
    }

}
