package ru.yandex.crypta.search.custom_audience;

import java.util.regex.Pattern;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.lab.LabMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class CustomAudienceMatcher extends LabMatcher implements RegexMatcher {
    @Override
    public Pattern regex() {
        return Pattern.compile("^custom_audience(?<args>.*)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("custom_audience gender=male age=25-34");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }

        var args = matcher.group("args");
        var getStatsRequest = ParamsParser.parseArgs(args);

        if (getStatsRequest == null) {
            var response = createResponse();
            response.setSource("CustomAudience");
            response.getValueBuilder().setText(ParamsParser.usage());
            yield.yield(response.build());
            return;
        }

        var stats = getLabService(context.getLanguage()).getCustomAudienceStats(getStatsRequest);
        if (stats.isEmpty()) {
            return;
        }
        var response = createResponse();
        response.setSource("CustomAudience");
        response.getValueBuilder()
                .getUserDataStatsBuilder()
                .setId("none")
                .setStats(stats.orElseThrow());
        yield.yield(response.build());
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show Custom Audience stats"
        ));
    }
}
