package ru.yandex.crypta.search.dmp;

import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.crypta.service.dmp.DmpService;

public class DmpMatcher implements RegexMatcher {

    @Inject
    private DmpService dmp;

    @Override
    public Pattern regex() {
        return Pattern.compile("dmp");
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("dmp");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        dmp.getIndex().values().forEach(dmp -> {
            var value = createResponseValue();
            value.getDmpBuilder()
                    .setId(dmp.getId())
                    .setStatus(dmp.getStatus())
                    .setName(dmp.getName())
                    .setDmpLogin(dmp.getDmpLogin())
                    .setTag(dmp.getTag());
            yield.yield(createResponse().setSource("YT").setValue(value).build());
        });
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Get list of DMPs"
        ));
    }

}
