package ru.yandex.crypta.search.id;

import java.util.List;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.graph.Duid;
import ru.yandex.crypta.graph.Identifier;

public class DuidMatcher extends HumanishIdMatcher {
    @Override
    public Identifier getIdentifier(String query) {
        return new Duid(query);
    }

    @Override
    public List<String> getIdentifierAliases() {
        return List.of("duid");
    }

    @Override
    public BigbIdType getBigbIdType() {
        return BigbIdType.DUID;
    }
}
