package ru.yandex.crypta.search.id;

import java.util.List;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.graph.Gaid;
import ru.yandex.crypta.graph.Identifier;

public class GaidMatcher extends HumanishIdMatcher {

    @Override
    public Identifier getIdentifier(String query) {
        return new Gaid(query);
    }

    @Override
    public List<String> getIdentifierAliases() {
        return List.of("gaid", "device_id", "deviceid");
    }

    @Override
    public BigbIdType getBigbIdType() {
        return BigbIdType.GAID;
    }
}
