package ru.yandex.crypta.search.id;

import java.util.List;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.graph.Identifier;
import ru.yandex.crypta.graph.Idfa;

public class IdfaMatcher extends HumanishIdMatcher {

    @Override
    public Identifier getIdentifier(String query) {
        return new Idfa(query);
    }

    @Override
    public List<String> getIdentifierAliases() {
        return List.of("idfa", "ifa", "device_id", "deviceid");
    }

    @Override
    public BigbIdType getBigbIdType() {
        return BigbIdType.IDFA;
    }

}
