package ru.yandex.crypta.search.id;

import java.util.List;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.graph.Identifier;
import ru.yandex.crypta.graph.MmDeviceId;

public class MmDeviceIdMatcher extends HumanishIdMatcher {

    @Override
    public Identifier getIdentifier(String query) {
        return new MmDeviceId(query);
    }

    @Override
    public List<String> getIdentifierAliases() {
        return List.of("mm_device_id", "device_id", "deviceid");
    }

    @Override
    public BigbIdType getBigbIdType() {
        return BigbIdType.MM_DEVICE_ID;
    }
}
