package ru.yandex.crypta.search.id;

import java.util.Objects;
import java.util.regex.Pattern;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.common.ws.jersey.ContextIdentifiers;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class MyPuidMatcher implements RegexMatcher {

    @Inject
    private Provider<ContainerRequestContext> requestContext;

    @Override
    public Pattern regex() {
        return Pattern.compile("(my puid)|(мой puid)|(мой пуид)|(puid$)");
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("my puid");
        yield.yield("puid");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var puid = ContextIdentifiers.getPuid(requestContext.get());
        if (Objects.isNull(puid)) {
            return;
        }
        var result = createResponseValue().setText(puid).build();
        yield.yield(createResponse()
                .setSource("api")
                .setValue(result)
                .build());
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Your yandex-team.ru puid (not yandex.ru common puid!)"
        ));
    }


}
