package ru.yandex.crypta.search.id;

import java.util.List;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.graph.Identifier;
import ru.yandex.crypta.graph.Puid;

public class PuidMatcher extends HumanishIdMatcher {

    @Override
    public Identifier getIdentifier(String query) {
        return new Puid(query);
    }

    @Override
    public List<String> getIdentifierAliases() {
        return List.of("puid", "passportuid", "passportid");
    }

    @Override
    public BigbIdType getBigbIdType() {
        return BigbIdType.PUID;
    }
}
