package ru.yandex.crypta.search.id;

import java.util.List;

import ru.yandex.crypta.clients.bigb.BigbIdType;
import ru.yandex.crypta.graph.Identifier;
import ru.yandex.crypta.graph.Uuid;

public class UuidMatcher extends HumanishIdMatcher {

    @Override
    public Identifier getIdentifier(String query) {
        return new Uuid(query);
    }

    @Override
    public List<String> getIdentifierAliases() {
        return List.of("uuid", "app");
    }

    @Override
    public BigbIdType getBigbIdType() {
        return BigbIdType.UUID;
    }
}
