package ru.yandex.crypta.search.keyword;

import java.util.Optional;
import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Search.TKeywordInfo;
import ru.yandex.crypta.search.proto.Service;

public class KeywordIdMatcher implements RegexMatcher {

    private final KeywordsService keywordsService;

    @Inject
    public KeywordIdMatcher(KeywordsService keywordsService) {
        this.keywordsService = keywordsService;
    }

    @Override
    public Pattern regex() {
        return Pattern.compile("^keyword (?<id>[0-9]+)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("keyword 217");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }

        var id = Long.valueOf(matcher.group("id"));
        var description = Optional.ofNullable(keywordsService.getKeywordDescriptionById(id));
        var keywordDataType = Optional.ofNullable(keywordsService.getKeywordDataTypeById(id));

        if (description.isEmpty() && keywordDataType.isEmpty()) {
            return;
        }

        TKeywordInfo.Builder keywordInfo = Search.TKeywordInfo.newBuilder();

        description.ifPresent(keywordInfo::setDescription);
        keywordDataType.ifPresent(keywordInfo::addDataTypes);

        yield.yield(createResponse()
                .setValue(createResponseValue().setKeyword(keywordInfo))
                .setSource("YT")
                .build());
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show BigB keyword description"
        ));
    }

}
