package ru.yandex.crypta.search.keyword;

import java.util.Map;
import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Search.TKeywordDescriptions;
import ru.yandex.crypta.search.proto.Service;

public class KeywordsMatcher implements RegexMatcher {

    private final KeywordsService keywordsService;

    @Inject
    public KeywordsMatcher(KeywordsService keywordsService) {
        this.keywordsService = keywordsService;
    }

    @Override
    public Pattern regex() {
        return Pattern.compile("keywords");
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("keywords");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        Map<Long, String> keywordDescriptions = keywordsService.getKeywordDescriptions();

        TKeywordDescriptions.Builder keywordDescriptionsBuilder = Search.TKeywordDescriptions.newBuilder();

        keywordDescriptionsBuilder.putAllValues(keywordDescriptions);

        yield.yield(createResponse()
                .setValue(createResponseValue().setKeywords(keywordDescriptionsBuilder))
                .setSource("YT")
                .build());
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show all BigB keywords"
        ));
    }
}
