package ru.yandex.crypta.search.lab;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.SecurityContext;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.lab.LabService;
import ru.yandex.crypta.search.Matcher;

public abstract class LabMatcher implements Matcher {

    @Inject
    private Provider<LabService> lab;

    @Inject
    private Provider<SecurityContext> securityContextProvider;

    protected LabService getLabService(Language language) {
        return lab.get().withLanguage(Language.orDefault(language)).withSecurityContext(securityContextProvider.get());
    }

}
