package ru.yandex.crypta.search.lab;

import java.util.regex.Pattern;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.common.exception.NotFoundException;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class LabSegmentMatcher extends LabMatcher implements RegexMatcher {
    private final static Logger LOG = LoggerFactory.getLogger(LabSegmentMatcher.class);

    @Override
    public Pattern regex() {
        return Pattern.compile("(segment-.+)");
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("segment-1337");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        try {
            var segment = getLabService(context.getLanguage()).segments().get(request.getQuery());
            var result = createResponseValue();
            result.getLabSegmentBuilder().setSegment(segment);
            // TODO add stats
            Search.TResponse.Builder response = createResponse()
                    .setSource("lab")
                    .setValue(result);
            yield.yield(response.build());
        } catch (NotFoundException ex) {
            LOG.error("Not found", ex);
        }
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show Crypta Lab segment Siberia stats"
        ));
    }

}
