package ru.yandex.crypta.search.lab;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import javax.inject.Inject;

import ru.yandex.crypta.audience.proto.TUserData;
import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lib.yt.YtReadingUtils;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.id.YandexuidMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public class UserDataMatcher extends YandexuidMatcher {

    private static final YPath USERDATA =
            YPath.simple("//home/crypta/production/lab/data/UserData");
    private static final YTableEntryType<TUserData>
            USER_DATA_ENTRY_TYPE = YTableEntryTypes.nativeProto(TUserData.class);

    @Inject
    private YtService yt;

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
        super.roles(request, yield);
        yield.yield(Roles.Portal.PROFILE);
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var userData = getUserData(extractId(request.getQuery()));
        userData
                .stream()
                .map(x -> {
                    var response = createResponse();
                    response.setSource("yt");
                    response.getValueBuilder()
                            .getUserDataBuilder()
                            .setUserData(x);
                    return response.build();
                })
                .forEach(yield::yield);
    }

    private List<TUserData> getUserData(String query) {
        var id = getIdentifier(query).getValue();
        var path = USERDATA.withExact(YtReadingUtils.exact(id));
        var result = new ArrayList<TUserData>(1);
        yt.getHahn().tables().read(path, USER_DATA_ENTRY_TYPE, (Consumer<TUserData>) result::add);
        return result;
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show yandexuid UserData"
        ));
    }

}
