package ru.yandex.crypta.search.links;

import java.util.concurrent.TimeUnit;

import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Query;

public interface AdreasonsApi {

    @GET("/debug")
    Call<ResponseBody> getDebugInfo(@Query("hit-log-id") String hitLogId);

    @GET("/statmx")
    Call<ResponseBody> getStatMx(@Query("hit-log-id") String hitLogId);

    static AdreasonsApi getApi() {
        var client = new OkHttpClient.Builder()
                .readTimeout(10, TimeUnit.SECONDS)
                .build();
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("adreasons.crypta.yandex-team.ru").port(443).build();
        var retrofit = new Retrofit.Builder().baseUrl(url).client(client).build();
        return retrofit.create(AdreasonsApi.class);
    }

}
