package ru.yandex.crypta.search.links;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

import com.google.common.base.Splitter;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class AdsdkLinkMatcher implements RegexMatcher {

    @Override
    public Pattern regex() {
        return YabsHelper.adsdkCountLinkRegex();
    }

    @Override
    public void examples(Yield<String> yield) {
        YabsHelper.adsdkCountLinkExamples().forEach(yield::yield);
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        try {
            var url = new URL(request.getQuery());
            var path = url.getPath();
            var countLink = Splitter.on(Pattern.compile("an\\.yandex\\.ru")).splitToList(path).get(1);

            var builder = YabsHelper.decode("https://an.yandex.ru" + countLink);

            yield.yield(createResponse()
                    .setValue(createResponseValue().setCountLink(builder))
                    .setSource("api")
                    .build());

        } catch (MalformedURLException e) {
            throw Exceptions.notFound();
        }
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Decode http://adsdk.yandex.ru/... redirect link"
        ));
    }

}
