package ru.yandex.crypta.search.links;

import java.util.regex.Pattern;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class CountLinkMatcher implements RegexMatcher {

    @Override
    public Pattern regex() {
        return YabsHelper.webCountLinkRegex();
    }

    @Override
    public void examples(Yield<String> yield) {
        YabsHelper.webCountLinkExamples().forEach(yield::yield);
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var builder = YabsHelper.decode(request.getQuery());

        yield.yield(createResponse()
                .setValue(createResponseValue().setCountLink(builder))
                .setSource("api")
                .build());
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Decode an.yandex.ru/yabs.yandex.ru count-link"
        ));
    }

}
