package ru.yandex.crypta.search.links;

import java.io.IOException;
import java.util.regex.Pattern;

import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class StatMxLinkMatcher implements RegexMatcher {

    private static final Logger LOG = LoggerFactory.getLogger(StatMxLinkMatcher.class);

    @Override
    public void examples(Yield<String> yield) {

    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {

    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var parameters = YabsHelper.toMap(YabsHelper.decode(request.getQuery()));
        var hitLogId = parameters.get("HitLogID");

        try {
            Response<ResponseBody> response = AdreasonsApi.getApi().getStatMx(hitLogId).execute();
            var responseJson = response.body().string();
            yield.yield(createResponse().setSource("api").setValue(createResponseValue().setStatMx(responseJson)).build());
        } catch (IOException e) {
            LOG.error("Failed to get statmx", e);
        }
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {

    }

    @Override
    public Pattern regex() {
        return YabsHelper.webCountLinkRegex();
    }
}
