package ru.yandex.crypta.search.lookalike;

import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.lab.siberia.SiberiaClient;
import ru.yandex.crypta.lib.yt.YtReadingUtils;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.crypta.search.siberia.YtToSiberiaStatsMatcher;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.lang.number.UnsignedLong;

public class GoalMatcher extends YtToSiberiaStatsMatcher implements RegexMatcher {

    private static final YPath GOALS_TABLE =
            YPath.simple("//home/crypta/production/lookalike/goal_audiences/goal_audiences");

    @Inject
    public GoalMatcher(
            SiberiaClient siberiaClient
    )
    {
        super(siberiaClient);
    }

    @Override
    public Pattern regex() {
        return Pattern.compile("^(goal|цель) (?<id>[0-9]+)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("goal 22");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }

        var id = UnsignedLong.valueOf(Long.parseUnsignedLong(matcher.group("id")));
        var path = GOALS_TABLE.withExact(YtReadingUtils.exact(id));

        yield.yield(describeFromYt(path, "yandexuid", "yandexuid"));
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show goal id Siberia stats"
        ));
    }
}
