package ru.yandex.crypta.search.misc;

import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.Matcher;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public class BmCategoryMatcher implements RegexMatcher {

    private static final YPath BM_CATEGORY_TABLE = YPath.simple("//home/yabs/dict/BMCategory");

    @Inject
    private YtService yt;

    @Override
    public Pattern regex() {
        return Pattern.compile("^(bm|category|bmcategory|bmcat)( |:|=)(?<id>[0-9]+)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Matcher.Yield<String> yield) {
        yield.yield("bmcategory 5758");
    }

    @Override
    public void roles(Service.TSearchRequest request, Matcher.Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Matcher.Context context, Matcher.Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }
        var id = matcher.group("id");
        yt.getHahn().tables().selectRows(getQuery(id), YTableEntryTypes.JACKSON_UTF8, each -> {
            var response = createResponse().setSource("YT");
            response.getValueBuilder().setJson(each.toString());
            yield.yield(response.build());
        });
    }

    private String getQuery(String id) {
        long bmId = Long.valueOf(id) + 200000000;
        return String.format("* FROM [%s] WHERE BMCategoryID = %d", BM_CATEGORY_TABLE.toString(), bmId);
    }

    @Override
    public void description(Matcher.Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show BM category description"
        ));
    }

}
