package ru.yandex.crypta.search.misc;

import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public class ExperimentsMatcher implements RegexMatcher {

    private static final YPath SELECT_TYPE_TABLE = YPath.simple("//home/yabs/dict/SelectType");

    @Inject
    private YtService yt;

    @Override
    public Pattern regex() {
        return Pattern.compile("^(exp|experiment|exp_id|эксперимент)( |:|=)(?<id>[0-9]+)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("exp 3");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }
        var id = matcher.group("id");

        yt.getHahn().tables().selectRows(getQuery(id), YTableEntryTypes.YSON, each -> {
            var response = createResponse().setSource("YT");
            var builder = response.getValueBuilder().getExperimentBuilder();

            builder.setId(each.getLong("ExperimentID"));
            builder.setDescription(each.getString("Description"));
            builder.setTrackerIssueId(each.getString("JiraID"));
            builder.setParameters(each.getString("Parameters"));
            yield.yield(response.build());
        });
    }

    private String getQuery(String id) {
        return String.format("* FROM [%s] WHERE ExperimentID = %s", SELECT_TYPE_TABLE.toString(), id);
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show old-style Experiment description"
        ));
    }

}
