package ru.yandex.crypta.search.misc;

import java.util.Objects;
import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.clients.geobase.GeobaseClient;
import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class GeobaseMatcher implements RegexMatcher {

    @Inject
    private GeobaseClient geobase;

    @Override
    public Pattern regex() {
        return Pattern.compile("(?<ip>^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$)|(?<id>[0-9]+)");
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("213");
        yield.yield("37.140.162.231");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }

        var lookup = geobase.getLookup();

        var ip = matcher.group("ip");
        if (Objects.nonNull(ip)) {
            var region = (int) lookup.getRegionIdByIp(ip);
            var linguistics = lookup.getLinguistics(region, context.toString());
            var result = createResponseValue();
            result.getRegionBuilder().setId(region).setName(linguistics.getNominativeCase());
            yield.yield(createResponse().setSource("geobase").setValue(result).build());
        }

        var id = matcher.group("id");
        if (Objects.nonNull(id)) {
            var linguistics = lookup.getLinguistics(Integer.valueOf(id), context.toString());
            var result = createResponseValue();
            result.getRegionBuilder().setId(Integer.valueOf(id)).setName(linguistics.getNominativeCase());
            yield.yield(createResponse().setSource("geobase").setValue(result).build());
        }
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Decode geobase id or show IP region"
        ));
    }

}
