package ru.yandex.crypta.search.misc;

import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public class PageMatcher implements RegexMatcher {

    private static final YPath PAGE_TABLE = YPath.simple("//home/yabs/dict/Page");

    @Inject
    private YtService yt;

    @Override
    public Pattern regex() {
        return Pattern.compile("^(page)( |:|=)(?<id>[0-9]+)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("page 123");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }
        var id = matcher.group("id");
        yt.getHahn().tables().selectRows(getQuery(id), YTableEntryTypes.JACKSON_UTF8, each -> {
            var response = createResponse().setSource("YT");
            response.getValueBuilder().setJson(each.toString());
            yield.yield(response.build());
        });
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show page description"
        ));
    }

    private String getQuery(String id) {
        long lId = Long.valueOf(id);
        return String.format("* FROM [%s] WHERE PageID = %d", PAGE_TABLE, lId);
    }

}
