package ru.yandex.crypta.search.misc;

import java.util.Comparator;
import java.util.Random;
import java.util.function.Function;
import java.util.regex.Pattern;

import javax.inject.Inject;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;
import ru.yandex.inside.yt.kosher.cypress.RangeLimit;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.inside.yt.kosher.ytree.YTreeStringNode;

public class RandomBannerMatcher implements RegexMatcher {

    private static final YPath BS_REQUEST_LOG = YPath.simple("//logs/bs-request-log/1d");

    @Inject
    private YtService yt;

    @Override
    public Pattern regex() {
        return Pattern.compile("(случайный баннер)|(random banner)");
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("random banner");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var latest = getLatestLog();
        var randomRow = fetchRandomRow(latest);
        var responsebody = randomRow.getStringO("responsebody");
        if (!responsebody.isPresent()) {
            return;
        }
        yield.yield(createResponse()
                .setSource("YT")
                .setValue(createResponseValue().setText(responsebody.get()))
                .build());
    }

    private YTreeMapNode fetchRandomRow(YPath path) {
        var rowCount = yt.getHahn().cypress().get(path.attribute("row_count")).longValue();
        var index = Long.remainderUnsigned(new Random().nextLong(), rowCount);
        var indexPath = path.withExact(RangeLimit.row(index));
        var records = yt.readTableYson(indexPath, Function.identity());
        return records.first();
    }

    private YPath getLatestLog() {
        return yt.getHahn()
                .cypress()
                .list(BS_REQUEST_LOG)
                .stream()
                .sorted(Comparator.comparing(YTreeStringNode::getValue))
                .findFirst()
                .map(x -> BS_REQUEST_LOG.child(x.getValue()))
                .orElseThrow(Exceptions::unavailable);
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show random banner"
        ));
    }
}
