package ru.yandex.crypta.search.repin;

import java.io.IOException;

import com.google.protobuf.util.JsonFormat;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.siberia.bin.custom_audience.common.proto.TExtendedCaRule;


public class ParamsParser {
    public static TExtendedCaRule parseArgs(String raw) {
        if (raw.trim().isEmpty()) {
            return null;
        }

        try {
            var builder = TExtendedCaRule.newBuilder();
            JsonFormat.parser().merge(raw, builder);
            var rule = builder.build();
            if (rule.toByteArray().length == 0) {
                return null;
            }
            return rule;
        } catch (IOException e) {
            throw Exceptions.wrongRequestException("Can't parse JSON. Error = " + e.getMessage(), "BAD_REQUEST");
        }
    }

    public static String usage() {
        return "Possible arg: JSON TExendedCaRule protobuf";
    }
}
