package ru.yandex.crypta.search.repin;

import java.util.regex.Pattern;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.lab.LabMatcher;
import ru.yandex.crypta.search.proto.Search;
import ru.yandex.crypta.search.proto.Service;

public class RepinMatcher extends LabMatcher implements RegexMatcher {
    @Override
    public Pattern regex() {
        return Pattern.compile("^repin(?<args>.*)$", Pattern.CASE_INSENSITIVE);
    }

    @Override
    public void examples(Yield<String> yield) {
        yield.yield("repin <json>");
    }

    @Override
    public void roles(Service.TSearchRequest request, Yield<String> yield) {
    }

    @Override
    public void process(Service.TSearchRequest request, Context context, Yield<Search.TResponse> yield) {
        var matcher = regex().matcher(request.getQuery());
        if (!matcher.matches()) {
            return;
        }

        var args = matcher.group("args");
        var extendedRule = ParamsParser.parseArgs(args);

        if (extendedRule == null) {
            var response = createResponse();
            response.setSource("Repin");
            response.getValueBuilder().setText(ParamsParser.usage());
            yield.yield(response.build());
            return;
        }

        var stats = getLabService(context.getLanguage()).getCustomAudienceStats(extendedRule);
        if (stats.isEmpty()) {
            return;
        }
        var response = createResponse();
        response.setSource("Repin");
        response.getValueBuilder()
                .getUserDataStatsBuilder()
                .setId("none")
                .setStats(stats.orElseThrow());
        yield.yield(response.build());
    }

    @Override
    public void description(Yield<Search.TMatcherDescription> yield) {
        yield.yield(createDescription(
                Language.EN, "Show audience portrait"
        ));
    }
}
