package ru.yandex.crypta.search.siberia;

import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.search.util.ParamsParsing;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class ParamsParser {
    private static final List<ParamsParsing.FieldParser> PARSERS;
    private static final String VERSION = "version";
    private static final String YT_PATH = "yt_path";

    static {
        PARSERS = List.of(
            new ParamsParsing.RegexAttributeParser(VERSION, "[a-z_0-9]+"),
            new ParamsParsing.RegexAttributeParser(YT_PATH, "//home/crypta/([a-zA-Z_\\-0-9]+/)+[a-zA-Z_\\-0-9]+")
        );
    }

    public static class Params {
        private Optional<String> version = Optional.empty();
        private Optional<YPath> ytPath = Optional.empty();

        void setVersion(String version) {
            this.version = Optional.of(version);
        }

        Optional<String> getVersion() {
            return version;
        }

        void setYtPath(YPath ytPath) {
            this.ytPath = Optional.of(ytPath);
        }

        Optional<YPath> getYtPath() {
            return ytPath;
        }
    }

    private static class ParamsConsumer implements ParamsParsing.Consumer {
        private Params params;

        public ParamsConsumer() {
            this.params = new Params();
        }

        @Override
        public <T> void consume(String fieldName, T value) {
            if (fieldName.equals(VERSION)) {
                params.setVersion(value.toString());
            } else if (fieldName.equals(YT_PATH)) {
                params.setYtPath(YPath.simple(value.toString()));
            } else {
                throw Exceptions.wrongRequestException(MessageFormat.format("Unknown param {}", fieldName), "BAD_REQUEST");
            }
        }

        @Override
        public <T> void consumeMultiple(String fieldName, Stream<T> values) {
            throw Exceptions.wrongRequestException("Multiple values are forbidden", "BAD_REQUEST");
        }

        public Params getParams() {
            return params;
        }
    }

    public static Params parseArgs(String rawArgs) {
        var paramsConsumer = new ParamsConsumer();

        ParamsParsing.parseArgs(rawArgs, PARSERS, paramsConsumer);

        return paramsConsumer.getParams();
    }
}
