package ru.yandex.crypta.search.siberia;

import java.util.Optional;

import javax.inject.Inject;

import com.google.protobuf.util.JsonFormat;
import okhttp3.MediaType;
import okhttp3.RequestBody;

import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.lab.siberia.SiberiaClient;
import ru.yandex.crypta.lib.proto.identifiers.TIds;
import ru.yandex.crypta.lib.yt.YtService;
import ru.yandex.crypta.search.RegexMatcher;
import ru.yandex.crypta.search.lab.LabMatcher;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;

public abstract class YtToSiberiaStatsMatcher extends LabMatcher implements RegexMatcher {

    public static final MediaType APPLICATION_JSON = MediaType.get("application/json");
    private static final int ROW_LIMIT = 100000;
    private final SiberiaClient siberiaClient;
    @Inject
    private YtService yt;

    protected YtToSiberiaStatsMatcher(
            SiberiaClient siberiaClient
    )
    {
        this.siberiaClient = siberiaClient;
    }

    protected ru.yandex.crypta.search.proto.Search.TResponse describeFromYt(YPath path, String idType, String column) {
        var ids = readIds(path, idType, column);

        var response = createResponse();
        response.setSource("Siberia");
        response.getValueBuilder().setJson(describeIds(ids));
        return response.build();
    }

    private TIds readIds(YPath path, String idType, String column) {
        var iter = yt.getHahn().tables().read(Optional.empty(), false, path, YTableEntryTypes.JACKSON).stream()
                .limit(ROW_LIMIT)
                .iterator();

        var idsBuilder = TIds.newBuilder();
        while (iter.hasNext()) {
            var builder = idsBuilder.addIdsBuilder();
            builder.setType(idType);
            builder.setValue(iter.next().get(column).asText());
        }

        var ids = idsBuilder.build();

        if (ids.getIdsCount() == 0) {
            throw Exceptions.notFound();
        }

        return ids;
    }

    private String describeIds(TIds ids) {
        var rawResponse = siberiaClient.tryCall(siberia -> {
            var body = RequestBody.create(APPLICATION_JSON, JsonFormat.printer().print(ids));
            return siberia.describeIds(body, "fast", "{\"CryptaIdUserDataVersion\": \"by_crypta_id\"}");
        });

        return rawResponse.getText();
    }
}
