package ru.yandex.crypta.search.util;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;

import ru.yandex.crypta.search.Matcher;

public class CollectYield<C extends Collection<T>, T> implements Matcher.Yield<T> {

    private C collected;
    private Predicate<T> shouldAccept;

    public CollectYield(Supplier<C> supplier) {
        this.collected = supplier.get();
        this.shouldAccept = (x) -> true;
    }

    public CollectYield(Supplier<C> supplier, Predicate<T> shouldAccept) {
        this.collected = supplier.get();
        this.shouldAccept = shouldAccept;
    }

    @Override
    public void yield(T element) {
        if (shouldAccept.test(element)) {
            collected.add(element);
        }
    }

    public C getCollected() {
        return collected;
    }
}
