package ru.yandex.crypta.search.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

import ru.yandex.crypta.search.Matcher;

public class ListYield<T> implements Matcher.Yield<T> {

    private List<T> collected;
    private Predicate<T> shouldAccept;

    public ListYield() {
        this.collected = new ArrayList<>();
        this.shouldAccept = (x) -> true;
    }

    public ListYield(Predicate<T> shouldAccept) {
        this.collected = new ArrayList<>();
        this.shouldAccept = shouldAccept;
    }

    @Override
    public void yield(T element) {
        if (shouldAccept.test(element)) {
            collected.add(element);
        }
    }

    public List<T> getCollected() {
        return collected;
    }

    public static <E> List<E> extract(Consumer<Matcher.Yield<E>> collect) {
        ListYield<E> toList = new ListYield<>();
        collect.accept(toList);
        return toList.getCollected();
    }

    public static <E> List<E> extract(Consumer<Matcher.Yield<E>> collect, Predicate<E> shouldAccept) {
        ListYield<E> toList = new ListYield<>(shouldAccept);
        collect.accept(toList);
        return toList.getCollected();
    }
}
