package ru.yandex.crypta.search.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

import ru.yandex.crypta.search.Matcher;

public class MapYield<K, V> implements Matcher.Yield<V> {

    private final Map<K, V> collected;
    private final Predicate<V> shouldAccept;
    private final Function<V, K> keyExtractor;

    public MapYield(Function<V, K> keyExtractor) {
        this.collected = new HashMap<>();
        this.shouldAccept = (x) -> true;
        this.keyExtractor = keyExtractor;

    }

    public MapYield(Function<V, K> keyExtractor, Predicate<V> shouldAccept) {
        this.collected = new HashMap<>();
        this.shouldAccept = shouldAccept;
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void yield(V element) {
        if (shouldAccept.test(element)) {
            collected.put(keyExtractor.apply(element), element);
        }
    }

    public Map<K, V> getCollected() {
        return collected;
    }

    public static <K, V> Map<K, V> extract(Consumer<Matcher.Yield<V>> consumer, Function<V, K> keyExtractor) {
        MapYield<K, V> toMap = new MapYield<>(keyExtractor);
        consumer.accept(toMap);
        return toMap.getCollected();
    }

    public static <K, V> Map<K, V> extract(Consumer<Matcher.Yield<V>> consumer, Function<V, K> keyExtractor,
                                           Predicate<V> shouldAccept) {
        MapYield<K, V> toMap = new MapYield<>(keyExtractor, shouldAccept);
        consumer.accept(toMap);
        return toMap.getCollected();
    }
}
