package ru.yandex.crypta.search.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.crypta.common.Language;
import ru.yandex.crypta.idm.LocalizedString;
import ru.yandex.crypta.idm.RoleDefinition;

public class RolesHelpers {

    private static final String NOT_AVAILABLE = "N/A";

    private static RoleDefinition getRoleDefinition(RoleDefinition roles, String id) {
        if (Objects.isNull(roles)) {
            return null;
        }
        return roles.getValues().get(id);
    }

    private static String localize(LocalizedString string, Language language) {
        if (language.isEn()) {
            return string.getEn();
        }
        if (language.isRu()) {
            return string.getRu();
        }
        return NOT_AVAILABLE;
    }

    public static String roleIdToPrettyName(String roleId, Language language) {
        var role = ru.yandex.crypta.idm.Roles.INSTANCE.fromId(roleId);
        if (Objects.isNull(role)) {
            return NOT_AVAILABLE;
        }
        var roleIds = new ArrayDeque<>(Stream.of(role.getGroup(), role.getSubgroup(), role.getSubsubgroup())
                .filter(Objects::nonNull)
                .collect(Collectors.toList()));
        var path = new ArrayList<String>(roleIds.size() + 1);

        var current = RoleDefinition.builder()
                .setName(ru.yandex.crypta.idm.Roles.INSTANCE.root().getName())
                .setRoles(ru.yandex.crypta.idm.Roles.INSTANCE.root())
                .build();
        while (Objects.nonNull(current)) {
            path.add(localize(current.getName(), language));
            if (!roleIds.isEmpty()) {
                current = getRoleDefinition(current.getRoles(), roleIds.pollFirst());
            } else {
                current = null;
            }
        }

        if (path.isEmpty()) {
            return NOT_AVAILABLE;
        } else {
            return String.join(" / ", path);
        }
    }

}
