package ru.yandex.crypta.search.util;

import java.io.Closeable;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;

public class Timer implements Closeable {

    private final Instant start;

    public Timer() {
        start = Instant.now();
    }

    @Override
    public void close() {
    }

    public Duration sinceStart() {
        return Duration.between(start, Instant.now());
    }

    public static boolean withTimer(Function<Timer, Boolean> callback) {
        var timer = new Timer();
        return callback.apply(timer);
    }

}
