package ru.yandex.crypta.search.util;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;

import ru.yandex.misc.digest.Md5;
import ru.yandex.misc.lang.Check;

public class YabsHash {

    /**
     * Based on python impl from https://st.yandex-team.ru/CONTEXT-729
     * Performance is not guaranteed
     *
     * @param digest datta
     * @return md5 reduced to 64 bit
     */
    private static long halfMix(byte[] digest) {
        Check.equals(16, digest.length);

        IntBuffer ints = ByteBuffer.wrap(digest).asIntBuffer();

        int low = ints.get(0) ^ ints.get(2);
        int high = ints.get(1) ^ ints.get(3);

        long u64High = Integer.toUnsignedLong(high) << 32;
        long u64Low = Integer.toUnsignedLong(low);

        return u64High | u64Low;
    }

    public static long calcHalfMd5(byte[] data) {
        Md5.Sum digest = new Md5().digest(data);
        return halfMix(digest.getBytes());
    }

    public static String calcHalfMd5Str(byte[] data) {
        long half = calcHalfMd5(data);
        return Long.toUnsignedString(half);
    }
}
