#include "convert_to_user_data_stats_mapper.h"

#include <crypta/lab/lib/native/segments_user_data_stats_aggregator.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/siberia/bin/common/yt_schemas/cpp/schemas.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NCryptaIdUserData;
using namespace NCrypta::NSiberia::NConvertToUserDataStats;

void TConvertToUserDataStatsMapper::Do(TReader* reader, TWriter* writer) {
    NNativeYT::TProtoState<NLab::TUserDataStatsOptions> state;
    NLab::TSegmentsUserDataStatsAggregator aggregator(state);

    NLab::TUserDataStats userDataStats;

    for (; reader->IsValid(); reader->Next()) {
        const auto& userData = reader->GetRow();
        aggregator.ConvertUserDataToUserDataStats(userDataStats, userData, false);

        writer->AddRow(
            NYT::TNode()
                (NFields::CRYPTA_ID, FromString<ui64>(userData.GetCryptaID()))
                (NFields::STATS, NProtoSerializer::ToString(userDataStats))
        );
    }
}
