#include "describe_in_siberia.h"

#include <crypta/graph/soup/config/cpp/soup_config.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>
#include <crypta/lib/native/tvm/create_tvm_client.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/siberia/bin/common/describing/experiment/proto/describing_experiment.pb.h>

#include <library/cpp/bloom_filter/bloomfilter.h>
#include <yt/yt/core/concurrency/config.h>
#include <yt/yt/core/misc/shutdown.h>

#include <util/random/random.h>
#include <util/system/env.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

void TDescribeInSiberia::Start(TWriter* writer) {
    Y_UNUSED(writer);

    auto& tvm = *State->MutableTvm();
    tvm.SetSecret(GetEnv("YT_SECURE_VAULT_TVM_SECRET"));

    TvmClient = MakeHolder<NTvmAuth::TTvmClient>(CreateTvmClient(tvm));

    SiberiaClient = MakeHolder<TSiberiaClient>(State->GetHost(), State->GetPort(), TDuration::Seconds(State->GetTimeoutSec()), *TvmClient, MakeRetryOptions(State->GetRetryOptions()));

    Throttler = NYT::NConcurrency::CreateReconfigurableThroughputThrottler(
        NYT::New<NYT::NConcurrency::TThroughputThrottlerConfig>(State->GetMaxIdsPerSecond())
    );
}

void TDescribeInSiberia::Do(TReader* reader, TWriter* writer) {
    for (; reader->IsValid(); reader->Next()) {
        TGroupUserSet output;

        const auto& row = reader->GetRow();

        Throttler->Throttle(row.GetIds().GetIds().size()).Get();
        
        const auto& userSetId = SiberiaClient->DescribeIds(row.GetIds(), State->GetDescribingMode(), State->GetExperiment());

        output.SetGroupID(row.GetGroupID());
        output.SetUserSetID(userSetId);
        output.SetActualSegmentSize(row.GetActualSegmentSize());

        if (row.HasFilter()) {
            output.SetFilter(NProtoSerializer::ToString(row.GetFilter()));
        }

        writer->AddRow(output);
    }
}

void TDescribeInSiberia::Finish(TWriter*) {
    Throttler.Reset();
    NYT::Shutdown();
}
