#pragma once

#include <crypta/lab/lib/native/utils.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/siberia/bin/common/create_user_set_from_sample_reducer/proto/describe_in_siberia.pb.h>
#include <crypta/siberia/bin/common/create_user_set_from_sample_reducer/proto/ids_to_describe.pb.h>
#include <crypta/siberia/bin/common/create_user_set_from_sample_reducer/proto/group_user_set.pb.h>
#include <crypta/lib/proto/identifiers/id.pb.h>
#include <crypta/siberia/bin/common/siberia_client/cpp/siberia_client.h>

#include <library/cpp/tvmauth/client/facade.h>
#include <mapreduce/yt/interface/client.h>

#include <yt/yt/core/concurrency/throughput_throttler.h>

namespace NCrypta::NSiberia {
class TDescribeInSiberia : public TStateful<TDescribeInSiberiaState, NYT::IMapper<NYT::TTableReader<TIdsToDescribe>, NYT::TTableWriter<TGroupUserSet>>> {
    public:
        TDescribeInSiberia() = default;

        TDescribeInSiberia(const TBuffer& buffer)
            : TStateful(buffer)
        {
        }

        void Start(TWriter* writer) override;
        void Finish(TWriter* writer) override;

        void Do(TReader* reader, TWriter* writer) override;

    private:
        THolder<NTvmAuth::TTvmClient> TvmClient;
        THolder<TSiberiaClient> SiberiaClient;
        NYT::NConcurrency::IThroughputThrottlerPtr Throttler;
    };
}
