#pragma once

#include <crypta/lab/lib/native/utils.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/siberia/bin/common/create_user_set_from_sample_reducer/proto/user_group.pb.h>
#include <crypta/siberia/bin/common/create_user_set_from_sample_reducer/proto/pre_describe_filter_combiner_state.pb.h>
#include <crypta/siberia/bin/common/create_user_set_from_sample_reducer/proto/ids_to_describe.pb.h>

#include <mapreduce/yt/interface/client.h>


namespace NCrypta::NSiberia {
    class TPreDescribeFilterCombiner : public TStateful<TPreDescribeFilterCombinerState, NYT::IReducer<NYT::TTableReader<TUserGroup>, NYT::TTableWriter<TIdsToDescribe>>> {
    public:
        TPreDescribeFilterCombiner() = default;

        TPreDescribeFilterCombiner(const TBuffer& buffer)
            : TStateful(buffer)
        {
        }

        void Start(TWriter* writer) override;

        void Do(TReader* reader, TWriter* writer) override;

    private:
        TFilterIdentifier SkipFilter;
    };
}
