#include "user_set_helpers.h"

using namespace NCrypta::NSiberia;

bool NUserSetHelpers::IsMaterialized(const TUserSet& userSet) {
    return userSet.GetType() == USER_SET_TYPE.GetMaterialized();
}

bool NUserSetHelpers::IsMetaDataOnly(const TUserSet& userSet) {
    return userSet.GetStatus() == USER_SET_STATUS.GetMetaDataOnly();
}

bool NUserSetHelpers::IsReady(const TUserSet& userSet) {
    return userSet.GetStatus() == USER_SET_STATUS.GetReady();
}

bool NUserSetHelpers::IsValidUserSetStatus(const TString& status) {
    return status == USER_SET_STATUS.GetMetaDataOnly() || status == USER_SET_STATUS.GetNotReady() || status == USER_SET_STATUS.GetReady();
}

bool NUserSetHelpers::IsValidUserSetType(const TString& type) {
    return type == USER_SET_TYPE.GetNotMaterialized() || type == USER_SET_TYPE.GetMaterialized();
}
