#include "validator.h"

#include "invalid_describing_experiment_exception.h"

#include <crypta/siberia/bin/common/describing/paths/paths.h>

using namespace NCrypta;

void NSiberia::ValidateDescribingExperiment(TYdbClient& ydbClient, const TDescribingExperiment& experiment) {
    const auto& cryptaIdUserDataVersion = experiment.GetCryptaIdUserDataVersion();
    if (cryptaIdUserDataVersion != "") {
        try {
            GetUserDataTablePath(ydbClient, cryptaIdUserDataVersion);
        } catch (const yexception&) {
            ythrow TInvalidDescribingExperimentException() << "Make sure that experimental user data with version '" << cryptaIdUserDataVersion << "' exists in db";
        }
    }
}
