#include "user_data.h"

#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <util/generic/maybe.h>
#include <util/string/cast.h>

using namespace NCrypta;

namespace {
    template<typename TMessage, typename TType>
    void SetProtoValue(TMessage* message, const TMaybe<TType>& value) {
        if (value) {
            NProtoSerializer::FromString(*message, *value);
        }
    }
}

NLab::TUserData NSiberia::ParseUserData(NYdb::TResultSetParser& parser) {
    NLab::TUserData userData;

    SetProtoValue(userData.MutableAttributes(), parser.ColumnParser("Attributes").GetOptionalString());
    SetProtoValue(userData.MutableVectors(), parser.ColumnParser("Vectors").GetOptionalString());
    SetProtoValue(userData.MutableSegments(), parser.ColumnParser("Segments").GetOptionalString());
    SetProtoValue(userData.MutableIdentifiers(), parser.ColumnParser("Identifiers").GetOptionalString());
    SetProtoValue(userData.MutableAffinities(), parser.ColumnParser("Affinities").GetOptionalString());

    const auto withoutData = parser.ColumnParser("WithoutData").GetOptionalBool();
    if (withoutData.Defined()) {
        userData.SetWithoutData(*withoutData);
    }

    const auto groupId = parser.ColumnParser("GroupID").GetOptionalString();
    if (groupId.Defined()) {
        userData.SetGroupID(*groupId);
    }

    const auto cryptaId = parser.ColumnParser("CryptaID").GetOptionalString();
    if (cryptaId.Defined()) {
        userData.SetCryptaID(*cryptaId);
    }

    const auto yandexuid = parser.ColumnParser("yuid").GetOptionalUint64();
    if (yandexuid.Defined()) {
        userData.SetYandexuid(ToString(*yandexuid));
    }

    return userData;
}
