#include "paths.h"

#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/native/ydb/join.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;

TString NSiberia::GetUserDataTablePath(TYdbClient& ydbClient, const TString& version) {
    if (version == "") {
        return GetFreshestTablePath(ydbClient, YDB_PATHS.GetCryptaIdUserDataDir());
    }

    return GetFreshestTablePath(ydbClient, JoinYdbPath(YDB_PATHS.GetExperimentalCryptaIdUserDataRootDir(), version));
}

TString NSiberia::GetIdToCryptaIdTablePath(TYdbClient& ydbClient) {
    return GetFreshestTablePath(ydbClient, YDB_PATHS.GetIdToCryptaIdDir());
}
